/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 2002 Parametric Technology Corporation.
	All rights reserved.
*/

#pragma once

#include "resource.h"
using namespace ProDESKTOPLib;

/////////////////////////////////////////////////////////////////////////////

// ProdAddInCls
class ATL_NO_VTABLE ProdAddInCls :
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<ProdAddInCls, &CLSID_ProdAddInCls>,
	public IDispatchImpl<IProdAddInCls, &IID_IProdAddInCls, &LIBID_TABLEDIMADDINLib>,
	public IDispatchImpl<IProDAddIn, &IID_IProDAddIn, &LIBID_ProDESKTOPLib>,
	public IDispatchImpl<IUserCommandHandler, &IID_IUserCommandHandler, &LIBID_ProDESKTOPLib>
{
public:
	ProdAddInCls() { }

DECLARE_REGISTRY_RESOURCEID(IDR_PRODADDINCLS)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(ProdAddInCls)
	COM_INTERFACE_ENTRY(IProdAddInCls)
	COM_INTERFACE_ENTRY2(IDispatch, IProdAddInCls)
	COM_INTERFACE_ENTRY(IProDAddIn)
	COM_INTERFACE_ENTRY(IUserCommandHandler)
END_COM_MAP()

// IProdAddInCls
public:

	// IProDAddIn
	STDMETHOD(OnStartUp)();	// creates sub menu entry in main menu
	STDMETHOD(OnCloseDown)();	// deletes sub menu entry from main menu

	// IUserCommandHandler
	STDMETHOD(OnCommand)(IUserCommand *userCommand);	// command handler for "CreateLine"
	STDMETHOD(OnUpdateCommand)(IUserCommand *userCommand);
};
